#include <cstdio>
#include <cstdlib>
#include <cstring>
#include <cmath>
#include <ctime>
#include <cctype>
#include <iostream>
#include <iomanip>
#include <fstream>
#include <sstream>
#include <string>
#include <vector>
#include <set>
#include <algorithm>
#include <map>

using namespace std;

typedef long long ll;
typedef long double ld;
typedef long long unsigned ull;
typedef unsigned uint;

template <class T> inline T sqr(T x) { return x * x; }
template <class T> inline void updMin(T& a, const T& b) { if (b < a) a = b; }
template <class T> inline void updMax(T& a, const T& b) { if (b > a) a = b; }

struct Edge
{
	int a, b;
	int cost;
	Edge(int a_, int b_, int c_) : a(a_), b(b_), cost(c_) {}
	bool operator<(const Edge &to) const
	{
		return cost < to.cost || (cost == to.cost && a < to.a)
			|| (cost == to.cost && a == to.a && b < to.b);
	}
};

int n;
int cost[100][100];
vector< Edge > e;
vector< Edge > ans;
int cnt;

void dfs(int x, int col, int border, const set< int > &st, map< int, int > &color)
{
	color[x] = col;
	for (set< int >::const_iterator it = st.begin(); it != st.end(); ++it) {
		if (*it == x) {
			continue;
		}
		if (color[*it] == -1 && cost[x][*it] > border) {
			dfs(*it, col, border, st, color);
		}
	}
}

bool connect(set< int > v1)
{
	if (v1.size() == 1) {
		return true;
	}
	int optI = -1, optJ = -1;
	for (set< int >::iterator it1 = v1.begin(); it1 != v1.end(); ++it1) {
		for (set< int >::iterator it2 = v1.begin(); it2 != v1.end(); ++it2) {
			if (*it1 == *it2) {
				continue;
			}
			if (optI == -1 || cost[optI][optJ] > cost[*it1][*it2]) {
				optI = *it1;
				optJ = *it2;
			}
		}
	}
	if (optI == -1) {
		return false;
	}
	map< int, int > colored;
	for (set< int >::iterator it = v1.begin(); it != v1.end(); ++it) {
		colored[*it] = -1;
	}
	dfs(optI, 0, cost[optI][optJ], v1, colored);
	if (colored[optJ] == 0) {
		return false;
	}
	dfs(optJ, 1, cost[optI][optJ], v1, colored);
	set< int > nv1, nv2;
	for (map< int, int >::iterator it = colored.begin(); it != colored.end(); ++it) {
		if (it->second != 1) {
			nv1.insert(it->first);
		} else {
			nv2.insert(it->first);
		}
	}
	ans.push_back(Edge(optI, optJ, cost[optI][optJ]));
	return connect(nv1) && connect(nv2);
}

int main()
{
	//freopen("input.txt", "r", stdin); freopen("output.txt", "w", stdout);
	scanf("%d", &n);
	for (int i = 0; i < n; ++i) {
		for (int j = 0; j < n; ++j) {
			int cur_cost;
			scanf("%d", &cur_cost);
			cost[i + 1][j + 1] = cur_cost;
			if (i < j) {
				e.push_back(Edge(i + 1, j + 1, cur_cost));
			}
		}
	}
	set< int > allV;
	for (int i = 1; i <= n; ++i) {
		allV.insert(i);
	}
	cnt = n * (n - 1) / 2;
	if (connect(allV)) {
		printf("YES\n");
		printf("%d\n", int(ans.size()));
		for (int i = 0; i < int(ans.size()); ++i) {
			printf("%d %d %d\n", ans[i].a, ans[i].b, ans[i].cost);
		}
	} else {
		printf("NO\n");
	}
	return 0;
}